class Tower_Warlord extends Tower;

simulated function Tick(float DT) 
{
	Super.Tick(DT);
}

state TacticalMove
{
ignores SeePlayer, HearNoise;

	function FireAtEnemy()
	{
	local Pawn P;
	local float ClosestOne,ClosestTwo;
	local Pawn Target;
	local float Range;
	local PBPRI PRI;

	PRI = PBPRI(PlayerPawn(TowerOwner).PlayerReplicationInfo);
	
	if ( PRI.WarlordLevel == 0 )
		Range = 250;
	else if ( PRI.WarlordLevel >= 1 )
		Range = 350;
	
	Target = None;
	
	for ( P=Level.PawnList; P!=None; P=P.nextPawn )
		{
		if ( P.IsA('Balloon') )
			{
			if ( Balloon(P).bCamo && !PBPRI(TowerOwner.PlayerReplicationInfo).bHasCamoDetection)
				{
				//Player doesn't have camo detection na na na naaaaa naaaa :-P
				}
			else
				{
				if ( Vsize(P.Location - Location) < Range )
					{
					if ( Vsize(P.Location - Location) < ClosestOne || ClosestOne == 0 )
						{
						ClosestOne = Vsize(P.Location - Location);
						Target = P;
						}
					}
				}
			}
		}
	if ( Target != None )
		{
		Shoot(Target);
		Enemy = Target;
		MyTarget = Target;
		}
	else
		MyTarget = None;
	}

	function Shoot(Pawn Target)
	{
	local Vector FireSpot, ProjStart;
	local Proj_Tower_Warlord p;
	local Rotator FireRotation;
	
	PlaySound(FireSound, SLOT_None,5.0);

	ProjStart = Location;
	FireSpot = Target.Location + FMin(1, 0.7 + 0.6 * FRand()) * (Target.Velocity * VSize(Target.Location - ProjStart)/ProjectileType.Default.Speed);
	if ( !FastTrace(FireSpot, ProjStart) )
			FireSpot = 0.5 * (FireSpot + Target.Location);
	FireRotation = Rotator(Target.Location - Location);
	p = Spawn(Class'Proj_Tower_Warlord',TowerOwner,,ProjStart,FireRotation);
	P.Velocity *= 8;
	p.instigator = TowerOwner;
	PlayAnim('Fire');
	}
}

defaultproperties
{
	 TowerName="Warlord Tower"
	 ProjectileType=Class'Proj_Tower_Warlord'
	 FireSound=Sound'UnrealShare.Eightball.Ignite'
	 TimerSpeed(1)=1.5
	 TimerSpeed(2)=1.3
	 TimerSpeed(3)=1.1
	 TimerSpeed(4)=0.9
     DrawType=DT_Mesh
     Mesh=LodMesh'UnrealI.WarlordM'
     TransientSoundVolume=1.500000
     CollisionRadius=25.000000
     CollisionHeight=46.000000
     Mass=140.000000
     Buoyancy=140.000000
	 DrawScale=0.4
}
